/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import ca.lukegrahamlandry.lib.network.NetworkWrapper;
import ca.lukegrahamlandry.lib.network.ServerSideHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class HandshakeHelper
implements IEventCallbacks {
    private static final HashMap<String, ModProtocol> ACTIVE_VERSIONS = new HashMap();
    public static final HashMap<String, Predicate<String>> CLIENT_VERSION_CHECKERS = new HashMap();
    public static final HashMap<String, Predicate<String>> SERVER_VERSION_CHECKERS = new HashMap();

    public static void add(ModProtocol protocol) {
        ACTIVE_VERSIONS.put(protocol.modid, protocol);
    }

    private static void logProtocolVersions() {
        StringBuilder debug = new StringBuilder();
        for (ModProtocol protocol : ACTIVE_VERSIONS.values()) {
            debug.append(protocol).append(" ");
        }
        if (!debug.isEmpty()) {
            NetworkWrapper.LOGGER.info("Mod Protocol Versions: " + debug);
        }
    }

    @Override
    public void onPlayerLoginServer(Player player) {
        new HandshakeMessage(ACTIVE_VERSIONS.values()).sendToClient((ServerPlayer)player);
    }

    @Override
    public void onClientSetup() {
        HandshakeHelper.logProtocolVersions();
    }

    @Override
    public void onServerStarting(MinecraftServer server) {
        HandshakeHelper.logProtocolVersions();
    }

    public static class ModProtocol {
        String modid;
        String version;

        public ModProtocol(String modid, String version) {
            this.modid = modid;
            this.version = version;
        }

        public String toString() {
            return "(" + this.modid + ", " + this.version + ")";
        }
    }

    private static class HandshakeMessage
    implements ServerSideHandler,
    ClientSideHandler {
        public List<ModProtocol> mods;

        public HandshakeMessage(Collection<ModProtocol> mods) {
            this.mods = new ArrayList<ModProtocol>(mods);
        }

        @Override
        public void handle() {
            boolean accepted = this.validate(CLIENT_VERSION_CHECKERS, msg -> Minecraft.m_91087_().f_91074_.f_108617_.m_104910_().m_129507_(msg), "client");
            if (accepted) {
                NetworkWrapper.LOGGER.info("client accepts server's mod protocol versions");
                new HandshakeMessage(ACTIVE_VERSIONS.values()).sendToServer();
            }
        }

        @Override
        public void handle(ServerPlayer player) {
            this.validate(SERVER_VERSION_CHECKERS, msg -> player.f_8906_.m_9942_(msg), "server");
        }

        private boolean validate(HashMap<String, Predicate<String>> sidedVersionCheckers, Consumer<Component> sendDisconnect, String side) {
            for (ModProtocol protocol : this.mods) {
                boolean accepted;
                String otherSideVersion = protocol.version;
                try {
                    accepted = sidedVersionCheckers.getOrDefault(protocol.modid, s -> true).test(otherSideVersion);
                }
                catch (Exception e) {
                    accepted = false;
                }
                if (accepted) continue;
                sendDisconnect.accept(HandshakeMessage.error(protocol, side));
                return false;
            }
            return true;
        }

        private static Component error(ModProtocol protocol, String side) {
            String currentSideVersion = ACTIVE_VERSIONS.containsKey(protocol.modid) ? HandshakeHelper.ACTIVE_VERSIONS.get((Object)protocol.modid).version : "NONE";
            String otherSide = side.equals("server") ? "client" : "server";
            String v = protocol.modid + "'s active protocol versions are (" + side + ": " + currentSideVersion + ", " + otherSide + ": " + protocol.version + ")";
            NetworkWrapper.LOGGER.info(v);
            return Component.m_237113_((String)("Mod (" + protocol.modid + ") network protocol not accepted by " + side + ". Ensure client and server have same mod version. " + v));
        }
    }
}

