/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.config;

import ca.lukegrahamlandry.lib.config.Comment;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class GenerateComments {
    public static <T> String commentedJson(T instance, Gson gson) {
        return GenerateComments.commentedJson(instance, gson.newBuilder().setPrettyPrinting().create(), 1);
    }

    private static <T> String commentedJson(T instance, Gson gson, int level) {
        StringBuilder output;
        int comments = 0;
        for (Field field : instance.getClass().getFields()) {
            Comment annotation = field.getAnnotation(Comment.class);
            if (annotation == null) continue;
            ++comments;
        }
        if (comments == 0) {
            output = new StringBuilder();
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(gson.toJson(instance).split("\n")));
            output.append((String)lines.get(0));
            output.append("\n");
            lines.remove(0);
            for (String line : lines) {
                output.append("  ".repeat(level - 1));
                output.append(line);
                output.append("\n");
            }
            output.deleteCharAt(output.length() - 1);
            return output.toString();
        }
        output = new StringBuilder();
        output.append("  ".repeat(level - 1));
        output.append("{\n");
        for (Field field : instance.getClass().getFields()) {
            Object value;
            try {
                field.setAccessible(true);
                value = field.get(instance);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            Comment annotation = field.getAnnotation(Comment.class);
            if (annotation != null) {
                String comment = annotation.value();
                output.append("  ".repeat(level));
                output.append("// ").append(comment).append("\n");
            }
            output.append("  ".repeat(level));
            output.append("\"").append(field.getName()).append("\": ").append(GenerateComments.commentedJson(value, gson, level + 1)).append(",\n");
        }
        output.deleteCharAt(output.length() - 1);
        output.deleteCharAt(output.length() - 1);
        output.append("  ".repeat(level - 1));
        output.append("\n}\n");
        return output.toString();
    }
}

