/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.config;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import ca.lukegrahamlandry.lib.config.ConfigSyncMessage;
import ca.lukegrahamlandry.lib.config.ConfigWrapper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EventCallbacks
implements IEventCallbacks {
    @Override
    public void onServerStarting(MinecraftServer server) {
        ConfigWrapper.server = server;
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side.inWorldDir) {
                config.load();
            }
        });
    }

    @Override
    public void onServerStopped(MinecraftServer server) {
        ConfigWrapper.server = null;
    }

    @Override
    public void onPlayerLoginServer(Player player) {
        if (player.f_19853_.m_5776_()) {
            return;
        }
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side == ConfigWrapper.Side.SYNCED) {
                new ConfigSyncMessage((ConfigWrapper<?>)config).sendToClient((ServerPlayer)player);
            }
        });
    }

    @Override
    public void onClientSetup() {
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side == ConfigWrapper.Side.CLIENT) {
                config.load();
            }
        });
    }

    public static void onReloadCommand() {
        if (ConfigWrapper.server == null) {
            return;
        }
        ConfigWrapper.ALL.forEach(config -> {
            if (config.shouldReload && config.side.inWorldDir) {
                config.load();
                if (config.side == ConfigWrapper.Side.SYNCED) {
                    config.sync();
                }
            }
        });
    }
}

