/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.resources;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.resources.DataPackSyncMessage;
import ca.lukegrahamlandry.lib.resources.MergeRule;
import ca.lukegrahamlandry.lib.resources.forge.ResourcesWrapperImpl;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class ResourcesWrapper<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>> {
    static MinecraftServer server = null;
    static List<ResourcesWrapper<?>> ALL = new ArrayList();
    TypeToken<T> valueType;
    public final String directory;
    public final boolean isServerSide;
    Map<ResourceLocation, T> data;
    Logger logger;
    protected String suffix = ".json";
    private Gson gson = JsonHelper.get();
    boolean shouldSync = false;
    protected Runnable onLoadAction = () -> {};
    protected MergeRule<T> mergeRule = resources -> resources.get(resources.size() - 1);

    public static <T> ResourcesWrapper<T> data(Class<T> clazz, String directory) {
        return new ResourcesWrapper<T>(TypeToken.get(clazz), directory, true);
    }

    public static <T> ResourcesWrapper<T> assets(Class<T> clazz, String directory) {
        return new ResourcesWrapper<T>(TypeToken.get(clazz), directory, false);
    }

    public ResourcesWrapper<T> mergeWith(MergeRule<T> rule) {
        this.mergeRule = rule;
        return this;
    }

    public ResourcesWrapper<T> onLoad(Runnable action) {
        this.onLoadAction = action;
        return this;
    }

    public ResourcesWrapper<T> synced() {
        if (!this.isServerSide) {
            throw new RuntimeException("ResourcesWrapper#synced may only be called for data packs, NOT resource packs.");
        }
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called ResourcesWrapper#synced but WrapperLib Network module is missing.");
        }
        this.shouldSync = true;
        return this;
    }

    public ResourcesWrapper<T> withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public Set<Map.Entry<ResourceLocation, T>> entrySet() {
        return this.data.entrySet();
    }

    public T get(ResourceLocation id) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(id);
    }

    public boolean isLoaded() {
        return this.data != null;
    }

    public ResourcesWrapper(TypeToken<T> valueType, String directory, boolean isServerSide) {
        this.valueType = valueType;
        this.directory = directory;
        this.isServerSide = isServerSide;
        if (!this.isServerSide && Available.PLATFORM_HELPER.get() && PlatformHelper.isDedicatedServer()) {
            return;
        }
        ALL.add(this);
        ResourcesWrapper.registerResourceListener(this);
    }

    public Gson getGson() {
        return this.gson;
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, List<JsonElement>> results = new HashMap<ResourceLocation, List<JsonElement>>();
        for (Map.Entry entry : resourceManager.m_214160_(this.directory, file -> file.m_135815_().endsWith(this.suffix)).entrySet()) {
            String actualPath = ((ResourceLocation)entry.getKey()).m_135815_().substring(this.directory.length() + 1, ((ResourceLocation)entry.getKey()).m_135815_().length() - this.suffix.length());
            ResourceLocation id = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), actualPath);
            ArrayList<JsonElement> values = new ArrayList<JsonElement>();
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        values.add((JsonElement)this.getGson().fromJson((Reader)reader, JsonElement.class));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonSyntaxException e) {
                    this.logger.error("Failed to parse json for " + id + " from pack " + resource.m_215506_());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    this.logger.error("Failed to read " + id + " from pack " + resource.m_215506_());
                    e.printStackTrace();
                }
            }
            if (values.isEmpty()) continue;
            results.put(id, values);
        }
        return results;
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> resources, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        this.data = new HashMap<ResourceLocation, T>();
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : resources.entrySet()) {
            ResourceLocation id = entry.getKey();
            List<JsonElement> resourceStack = entry.getValue();
            ArrayList<Object> values = new ArrayList<Object>();
            for (JsonElement json : resourceStack) {
                values.add(this.getGson().fromJson(json, this.valueType.getType()));
            }
            T finalValue = this.mergeRule.merge(values);
            this.data.put(id, finalValue);
        }
        this.onLoadAction.run();
        if (this.shouldSync && server != null) {
            new DataPackSyncMessage(this).sendToAllClients();
        }
    }

    void set(Object value) {
        this.data = (Map)value;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerResourceListener(ResourcesWrapper<?> wrapper) {
        ResourcesWrapperImpl.registerResourceListener(wrapper);
    }
}

