/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network.forge;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import ca.lukegrahamlandry.lib.network.NetworkWrapper;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkWrapperImpl
implements IEventCallbacks {
    public static SimpleChannel channel;
    static int id;

    @Override
    public void onInit() {
        if (channel != null) {
            NetworkWrapper.LOGGER.error("onInit called twice");
            return;
        }
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)NetworkWrapper.ID, () -> "1.0", "1.0"::equals, "1.0"::equals);
        channel.registerMessage(id++, GenericHolder.class, GenericHolder::encodeBytes, GenericHolder::decodeBytes, NetworkWrapperImpl::handle);
    }

    public static void handle(GenericHolder<?> message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getSender() == null) {
                NetworkWrapper.handleClientPacket(message);
            } else {
                NetworkWrapper.handleServerPacket(((NetworkEvent.Context)context.get()).getSender(), message);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static <T> void sendToServer(T message) {
        channel.sendToServer(new GenericHolder<T>(message));
    }

    public static <T> void sendToClient(ServerPlayer player, T message) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), new GenericHolder<T>(message));
    }

    public static <T> void sendToAllClients(T message) {
        channel.send(PacketDistributor.ALL.noArg(), new GenericHolder<T>(message));
    }

    public static <T> void sendToTrackingClients(Entity entity, T message) {
        channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), new GenericHolder<T>(message));
    }

    public static <T> Packet<?> toVanillaPacket(T message, boolean isClientBound) {
        return channel.toVanillaPacket(new GenericHolder<T>(message), isClientBound ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER);
    }

    static {
        id = 0;
    }
}

