/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import ca.lukegrahamlandry.lib.network.HandshakeHelper;
import ca.lukegrahamlandry.lib.network.ServerSideHandler;
import ca.lukegrahamlandry.lib.network.forge.NetworkWrapperImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(NetworkWrapper.class);
    public static final Map<String, BiConsumer<ServerPlayer, ?>> SERVER_BOUND_HANDLERS = new HashMap();
    public static final Map<String, Consumer<?>> CLIENT_BOUND_HANDLERS = new HashMap();
    public static final ResourceLocation ID = new ResourceLocation("wrapperlib", NetworkWrapper.class.getPackageName());

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToServer(T message) {
        NetworkWrapperImpl.sendToServer(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToClient(ServerPlayer player, T message) {
        void var1_1;
        NetworkWrapperImpl.sendToClient(player, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToAllClients(T message) {
        NetworkWrapperImpl.sendToAllClients(message);
    }

    public static <T> void sendToTrackingClients(ServerLevel level, T message) {
        if (Objects.isNull(level)) {
            NetworkWrapper.sendToAllClients(message);
        }
        level.m_8795_(p -> true).forEach(p -> NetworkWrapper.sendToClient(p, message));
    }

    public static <T> void sendToTrackingClients(ServerLevel level, BlockPos pos, T message) {
        if (Objects.isNull(level) || Objects.isNull(pos)) {
            NetworkWrapper.sendToAllClients(message);
        } else {
            level.m_7726_().f_8325_.m_183262_(new ChunkPos(pos), false).forEach(p -> NetworkWrapper.sendToClient(p, message));
        }
    }

    public static <T> void sendToTrackingClients(BlockEntity tile, T message) {
        if (Objects.isNull(tile) || !tile.m_58898_() || tile.m_58904_().m_5776_()) {
            NetworkWrapper.sendToAllClients(message);
        } else {
            NetworkWrapper.sendToTrackingClients((ServerLevel)tile.m_58904_(), tile.m_58899_(), message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToTrackingClients(Entity entity, T message) {
        void var1_1;
        NetworkWrapperImpl.sendToTrackingClients(entity, var1_1);
    }

    public static <T> void sendToTrackingClientsAndSelf(ServerPlayer player, T message) {
        NetworkWrapper.sendToTrackingClients((Entity)player, message);
        NetworkWrapper.sendToClient(player, message);
    }

    public static <T> void registerClientHandler(Class<T> clazz, Consumer<T> handler) {
        CLIENT_BOUND_HANDLERS.put(clazz.getName(), handler);
    }

    public static <T> void registerServerHandler(Class<T> clazz, BiConsumer<ServerPlayer, T> handler) {
        SERVER_BOUND_HANDLERS.put(clazz.getName(), handler);
    }

    public static void handshake(String modid, String version, Predicate<String> clientCheckVersion, Predicate<String> serverCheckVersion) {
        HandshakeHelper.add(new HandshakeHelper.ModProtocol(modid, version));
        HandshakeHelper.CLIENT_VERSION_CHECKERS.put(modid, clientCheckVersion);
        HandshakeHelper.SERVER_VERSION_CHECKERS.put(modid, serverCheckVersion);
    }

    public static void handshake(String modid, String version) {
        NetworkWrapper.handshake(modid, version, version::equals, version::equals);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> Packet<?> toVanillaPacket(T message, boolean isClientBound) {
        void var1_1;
        return NetworkWrapperImpl.toVanillaPacket(message, (boolean)var1_1);
    }

    public static <T> Consumer<T> getClientHandler(Class<T> clazz) {
        if (CLIENT_BOUND_HANDLERS.containsKey(clazz.getName())) {
            return CLIENT_BOUND_HANDLERS.get(clazz.getName());
        }
        if (ClientSideHandler.class.isAssignableFrom(clazz)) {
            return obj -> ((ClientSideHandler)obj).handle();
        }
        return null;
    }

    public static <T> BiConsumer<ServerPlayer, T> getServerHandler(Class<T> clazz) {
        if (SERVER_BOUND_HANDLERS.containsKey(clazz.getName())) {
            return SERVER_BOUND_HANDLERS.get(clazz.getName());
        }
        if (ServerSideHandler.class.isAssignableFrom(clazz)) {
            return (sender, msg) -> ((ServerSideHandler)msg).handle((ServerPlayer)sender);
        }
        return null;
    }

    public static <T> boolean handleServerPacket(ServerPlayer player, GenericHolder<T> message) {
        BiConsumer<ServerPlayer, ServerPlayer> action = NetworkWrapper.getServerHandler(message.clazz);
        if (action == null) {
            LOGGER.error("No server bound packet handler registered for " + message.clazz.getName());
            return false;
        }
        try {
            action.accept(player, (ServerPlayer)message.value);
            return true;
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to handle packet: " + message.clazz);
            LOGGER.error("data: " + message.value);
            e.printStackTrace();
            return false;
        }
    }

    public static <T> boolean handleClientPacket(GenericHolder<T> message) {
        Consumer action = NetworkWrapper.getClientHandler(message.clazz);
        if (action == null) {
            LOGGER.error("No client bound packet handler registered for " + message.clazz.getName());
            return false;
        }
        try {
            action.accept(message.value);
            return true;
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to handle packet: " + message.clazz);
            LOGGER.error("data: " + message.value);
            e.printStackTrace();
            return false;
        }
    }
}

