/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.sync;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.TileFileDataWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileFileDataMessage
implements ClientSideHandler {
    String value;
    BlockPos pos;
    ResourceLocation dimension;
    String name;
    String dir;

    public <T> TileFileDataMessage(TileFileDataWrapper<T> wrapper, BlockEntity tile) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.pos = tile.m_58899_();
        this.dimension = tile.m_58904_().m_46472_().m_135782_();
        this.value = wrapper.getGson().toJson(wrapper.get(tile));
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (DataWrapper<?> data : DataWrapper.ALL) {
            if (!(data instanceof TileFileDataWrapper) || !Objects.equals(this.dir, data.getSubDirectory()) || !data.getName().equals(this.name)) continue;
            Object syncedValue = data.getGson().fromJson(this.value, data.clazz);
            ((TileFileDataWrapper)data).set(this.dimension, this.pos, syncedValue);
        }
        if (!handled) {
            DataWrapper.LOGGER.error("SingleMap. Received data sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
        }
    }
}

