/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.base;

import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class GenericHolder<T>
implements Supplier<T> {
    public final Class<T> clazz;
    public final T value;
    public static int NETWORK_MAX_CHARS = 32768;

    public GenericHolder(T value) {
        this.value = value;
        this.clazz = value.getClass();
    }

    @Override
    public T get() {
        return this.value;
    }

    public FriendlyByteBuf encodeBytes(FriendlyByteBuf buffer) {
        JsonObject data = JsonHelper.get().toJsonTree((Object)this).getAsJsonObject();
        buffer.m_130072_(data.toString(), NETWORK_MAX_CHARS);
        return buffer;
    }

    public static GenericHolder<?> decodeBytes(FriendlyByteBuf buffer) {
        String data = buffer.m_130136_(NETWORK_MAX_CHARS);
        return (GenericHolder)JsonHelper.get().fromJson(data, GenericHolder.class);
    }

    public static class TypeAdapter
    implements JsonDeserializer<GenericHolder<?>>,
    JsonSerializer<GenericHolder<?>> {
        public GenericHolder<?> deserialize(JsonElement data, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            String className = data.getAsJsonObject().get("clazz").getAsString();
            JsonElement valueJson = data.getAsJsonObject().get("value");
            try {
                Object value = ctx.deserialize(valueJson, Class.forName(className));
                return new GenericHolder<Object>(value);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException("error parsing GenericHolder. could not find class " + className);
            }
        }

        public JsonElement serialize(GenericHolder<?> obj, Type type, JsonSerializationContext ctx) {
            JsonObject out = new JsonObject();
            out.addProperty("clazz", obj.clazz.getName());
            out.add("value", ctx.serialize(obj.value));
            return out;
        }
    }
}

