/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl.file;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.file.MapFileHandler;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.world.level.storage.LevelResource;

public class SplitFileHandler<K, I, V>
implements MapFileHandler<K, I, V> {
    protected final MapDataWrapper<K, I, V> wrapper;

    public SplitFileHandler(MapDataWrapper<K, I, V> wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void save() {
        Gson pretty = this.wrapper.getGson().newBuilder().setPrettyPrinting().create();
        this.wrapper.data.forEach((key, value) -> {
            if (!this.wrapper.isDirty(key)) {
                return;
            }
            Path path = this.getFilePath(key);
            path.toFile().getParentFile().mkdirs();
            String json = pretty.toJson(value);
            try {
                Files.write(path, json.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.wrapper.logger.error("failed to write data to " + DataWrapper.forDisplay(path));
            }
        });
    }

    @Override
    public void load() {
        if (!this.getFolderPath().toFile().exists()) {
            return;
        }
        for (File file : this.getFolderPath().toFile().listFiles()) {
            try {
                BufferedReader reader = Files.newBufferedReader(file.toPath());
                String filename = file.getName().substring(0, file.getName().lastIndexOf("."));
                I id = this.wrapper.stringToId(filename);
                Object value = this.wrapper.getGson().fromJson((Reader)reader, this.wrapper.clazz);
                ((Reader)reader).close();
                this.wrapper.data.put(id, value);
            }
            catch (JsonSyntaxException | IOException e) {
                this.wrapper.logger.error("failed to load data from " + DataWrapper.forDisplay(file.toPath()));
                e.printStackTrace();
            }
        }
    }

    @Override
    public void clear(I id) {
        this.getFilePath(id).toFile().delete();
    }

    public Path getFilePath(I id) {
        return this.getFolderPath().resolve(id + "." + this.wrapper.fileExtension);
    }

    public Path getFolderPath() {
        Path path = DataWrapper.server.m_129843_(LevelResource.f_78182_).resolve("data");
        if (this.wrapper.getSubDirectory() != null) {
            path = path.resolve(this.wrapper.getSubDirectory());
        }
        return path;
    }
}

