/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl.file;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.file.SplitFileHandler;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;

public class LazyFileHandler<K, I, V>
extends SplitFileHandler<K, I, V> {
    public LazyFileHandler(MapDataWrapper<K, I, V> wrapper) {
        super(wrapper);
    }

    @Override
    public void load() {
    }

    public void load(I id) {
        if (!this.getFolderPath().toFile().exists()) {
            this.getFolderPath().toFile().mkdirs();
        }
        if (this.getFilePath(id).toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(this.getFilePath(id));
                Object value = this.wrapper.getGson().fromJson((Reader)reader, this.wrapper.clazz);
                ((Reader)reader).close();
                this.wrapper.data.put(id, value);
            }
            catch (JsonSyntaxException | IOException e) {
                this.wrapper.logger.error("failed to load data from " + DataWrapper.forDisplay(this.getFilePath(id)));
                e.printStackTrace();
            }
        }
    }
}

