/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.data.impl;

import ca.lukegrahamlandry.lib.base.WorkInProgress;
import ca.lukegrahamlandry.lib.data.sync.TileFileDataMessage;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

@WorkInProgress
public class TileFileDataWrapper<V> extends LevelDataWrapper<Map<class_2338, V>> {
    public TileFileDataWrapper(Class<Map<class_2338, V>> clazz) {
        super(clazz);  // wont work until i switch to using type tokens
    }

    public V get(class_2586 key) {
        if (!key.method_11002()) return null;
        return get(key.method_10997()).get(key.method_11016());
    }

    public void setDirty(class_2586 key) {
        this.isDirty = true;
        if (!key.method_11002()) return;
        if (this.shouldSync) new TileFileDataMessage(this, key).sendToAllClients();
    }

    public void clear(class_2586 key) {
        if (!key.method_11002()) return;
        get(key.method_10997()).remove(key.method_11016());
    }

    public void set(class_2960 dim, class_2338 pos, Object value) {
        getById(dim).put(pos, (V) value);
    }
}
