/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.resources;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EventCallbacks implements IEventCallbacks {
    @Override
    public void onPlayerLoginServer(class_1657 player){
        if (player.field_6002.method_8608()) return;

        ResourcesWrapper.ALL.forEach((resources) -> {
            if (resources.shouldSync) new DataPackSyncMessage(resources).sendToClient((class_3222) player);
        });
    }

    @Override
    public void onServerStarting(MinecraftServer server){
        ResourcesWrapper.server = server;
    }

    @Override
    public void onServerStopped(MinecraftServer server){
        ResourcesWrapper.server = null;
    }
}
