/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.event;

import ca.lukegrahamlandry.lib.base.InternalUseOnly;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.server.MinecraftServer;

@InternalUseOnly
public interface IEventCallbacks {
    default void onServerStarting(MinecraftServer server) {}

    default void onServerStopped(MinecraftServer server) {}

    default void onLevelSave(class_1936 level) {}

    default void onPlayerLoginServer(class_1657 player) {}

    default void onClientSetup() {}

    default void onInit() {}

    // TODO. needs mixin?
    // default void onReloadCommand() {}
}
