/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import ca.lukegrahamlandry.lib.network.HandshakeHelper;
import ca.lukegrahamlandry.lib.network.ServerSideHandler;
import ca.lukegrahamlandry.lib.network.fabric.NetworkWrapperImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkWrapper {
    public static final Logger LOGGER = LoggerFactory.getLogger(NetworkWrapper.class);
    public static final Map<String, BiConsumer<class_3222, ?>> SERVER_BOUND_HANDLERS = new HashMap();
    public static final Map<String, Consumer<?>> CLIENT_BOUND_HANDLERS = new HashMap();
    public static final class_2960 ID = new class_2960("wrapperlib", NetworkWrapper.class.getPackageName());

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToServer(T message) {
        NetworkWrapperImpl.sendToServer(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToClient(class_3222 player, T message) {
        void var1_1;
        NetworkWrapperImpl.sendToClient(player, var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToAllClients(T message) {
        NetworkWrapperImpl.sendToAllClients(message);
    }

    public static <T> void sendToTrackingClients(class_3218 level, T message) {
        if (Objects.isNull(level)) {
            NetworkWrapper.sendToAllClients(message);
        }
        level.method_18766(p -> true).forEach(p -> NetworkWrapper.sendToClient(p, message));
    }

    public static <T> void sendToTrackingClients(class_3218 level, class_2338 pos, T message) {
        if (Objects.isNull(level) || Objects.isNull(pos)) {
            NetworkWrapper.sendToAllClients(message);
        } else {
            level.method_14178().field_17254.method_17210(new class_1923(pos), false).forEach(p -> NetworkWrapper.sendToClient(p, message));
        }
    }

    public static <T> void sendToTrackingClients(class_2586 tile, T message) {
        if (Objects.isNull(tile) || !tile.method_11002() || tile.method_10997().method_8608()) {
            NetworkWrapper.sendToAllClients(message);
        } else {
            NetworkWrapper.sendToTrackingClients((class_3218)tile.method_10997(), tile.method_11016(), message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void sendToTrackingClients(class_1297 entity, T message) {
        void var1_1;
        NetworkWrapperImpl.sendToTrackingClients(entity, var1_1);
    }

    public static <T> void sendToTrackingClientsAndSelf(class_3222 player, T message) {
        NetworkWrapper.sendToTrackingClients((class_1297)player, message);
        NetworkWrapper.sendToClient(player, message);
    }

    public static <T> void registerClientHandler(Class<T> clazz, Consumer<T> handler) {
        CLIENT_BOUND_HANDLERS.put(clazz.getName(), handler);
    }

    public static <T> void registerServerHandler(Class<T> clazz, BiConsumer<class_3222, T> handler) {
        SERVER_BOUND_HANDLERS.put(clazz.getName(), handler);
    }

    public static void handshake(String modid, String version, Predicate<String> clientCheckVersion, Predicate<String> serverCheckVersion) {
        HandshakeHelper.add(new HandshakeHelper.ModProtocol(modid, version));
        HandshakeHelper.CLIENT_VERSION_CHECKERS.put(modid, clientCheckVersion);
        HandshakeHelper.SERVER_VERSION_CHECKERS.put(modid, serverCheckVersion);
    }

    public static void handshake(String modid, String version) {
        NetworkWrapper.handshake(modid, version, version::equals, version::equals);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> class_2596<?> toVanillaPacket(T message, boolean isClientBound) {
        void var1_1;
        return NetworkWrapperImpl.toVanillaPacket(message, (boolean)var1_1);
    }

    public static <T> Consumer<T> getClientHandler(Class<T> clazz) {
        if (CLIENT_BOUND_HANDLERS.containsKey(clazz.getName())) {
            return CLIENT_BOUND_HANDLERS.get(clazz.getName());
        }
        if (ClientSideHandler.class.isAssignableFrom(clazz)) {
            return obj -> ((ClientSideHandler)obj).handle();
        }
        return null;
    }

    public static <T> BiConsumer<class_3222, T> getServerHandler(Class<T> clazz) {
        if (SERVER_BOUND_HANDLERS.containsKey(clazz.getName())) {
            return SERVER_BOUND_HANDLERS.get(clazz.getName());
        }
        if (ServerSideHandler.class.isAssignableFrom(clazz)) {
            return (sender, msg) -> ((ServerSideHandler)msg).handle((class_3222)sender);
        }
        return null;
    }

    public static <T> boolean handleServerPacket(class_3222 player, GenericHolder<T> message) {
        BiConsumer<class_3222, class_3222> action = NetworkWrapper.getServerHandler(message.clazz);
        if (action == null) {
            LOGGER.error("No server bound packet handler registered for " + message.clazz.getName());
            return false;
        }
        try {
            action.accept(player, (class_3222)message.value);
            return true;
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to handle packet: " + message.clazz);
            LOGGER.error("data: " + message.value);
            e.printStackTrace();
            return false;
        }
    }

    public static <T> boolean handleClientPacket(GenericHolder<T> message) {
        Consumer action = NetworkWrapper.getClientHandler(message.clazz);
        if (action == null) {
            LOGGER.error("No client bound packet handler registered for " + message.clazz.getName());
            return false;
        }
        try {
            action.accept(message.value);
            return true;
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to handle packet: " + message.clazz);
            LOGGER.error("data: " + message.value);
            e.printStackTrace();
            return false;
        }
    }
}

