/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.nbt;

import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import ca.lukegrahamlandry.lib.data.nbt.ItemStackDataWrapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NbtDataWrapper<O, V> {
    public static final String PARENT_TAG_KEY = "WrapperLib";
    Map<Integer, V> previousDataObjects = new HashMap<Integer, V>();
    protected TypeToken<V> valueType;
    protected Logger logger;
    private String name;
    private Gson gson;

    public static <V> ItemStackDataWrapper<V> itemStack(Class<V> clazz) {
        return new ItemStackDataWrapper(TypeToken.get(clazz));
    }

    public <W extends NbtDataWrapper<O, V>> W named(String name) {
        this.name = name;
        this.createLogger();
        return (W)this;
    }

    public <W extends NbtDataWrapper<O, V>> W named(class_2960 name) {
        return this.named(name.toString());
    }

    public <W extends NbtDataWrapper<O, V>> W withGson(Gson gson) {
        this.gson = gson;
        return (W)this;
    }

    public V get(O obj) {
        Object value;
        int hashcode = this.getHashCode(obj);
        if (this.previousDataObjects.containsKey(hashcode)) {
            return this.previousDataObjects.get(hashcode);
        }
        if (this.getSharedTag(obj).method_10545(this.getFullTagKey())) {
            String data = this.getSharedTag(obj).method_10558(this.getFullTagKey());
            try {
                value = this.getGson().fromJson(data, this.valueType.getType());
            }
            catch (JsonSyntaxException e) {
                this.logger.error("Using default. Failed to parse data: " + data);
                e.printStackTrace();
                value = this.getDefaultInstance();
            }
        } else {
            value = this.getDefaultInstance();
        }
        this.previousDataObjects.put(this.getHashCode(obj), value);
        return value;
    }

    public void set(O obj, V value) {
        String data = this.getGson().toJson(value);
        this.getSharedTag(obj).method_10582(this.getFullTagKey(), data);
        this.previousDataObjects.put(this.getHashCode(obj), value);
    }

    public void setDirty(O obj) {
        this.set(obj, this.previousDataObjects.get(this.getHashCode(obj)));
    }

    public void remove(O obj) {
        this.previousDataObjects.remove(this.getHashCode(obj));
        this.getSharedTag(obj).method_10551(this.getFullTagKey());
    }

    public NbtDataWrapper(TypeToken<V> valueType) {
        this.valueType = valueType;
        this.named(valueType.getRawType().getSimpleName());
    }

    String getFullTagKey() {
        return this.name;
    }

    private V getDefaultInstance() {
        try {
            return (V)this.valueType.getRawType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error(this.valueType.getRawType().getName() + " does not have a public parameterless constructor");
            throw new RuntimeException(this.valueType.getRawType().getName() + " does not have a public parameterless constructor", e);
        }
    }

    protected abstract class_2487 getSharedTag(O var1);

    protected abstract int getHashCode(O var1);

    public Gson getGson() {
        return this.gson == null ? JsonHelper.get() : this.gson;
    }

    protected void createLogger() {
        String id = this.getClass().getName() + ": " + this.name;
        this.logger = LoggerFactory.getLogger((String)id);
    }
}

