/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.resources.fabric;

import ca.lukegrahamlandry.lib.resources.ResourcesWrapper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class ResourcesWrapperImpl {
    public static void registerResourceListener(ResourcesWrapper<?> wrapper){
        ResourceManagerHelper.get(wrapper.isServerSide ? class_3264.field_14190 : class_3264.field_14188).registerReloadListener(new Listener(wrapper));
    }

    private static class Listener implements IdentifiableResourceReloadListener {
        private final ResourcesWrapper<?> wrapper;

        private Listener(ResourcesWrapper<?> wrapper){
            this.wrapper = wrapper;
        }

        @Override
        public class_2960 getFabricId() {
            return new class_2960("wrapperlib", this.wrapper.directory);
        }

        @Override
        public CompletableFuture<Void> method_25931(class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
            return wrapper.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
        }
    }
}
