/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.registry;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.helper.EntityHelper;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.registry.RegistryWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5617;
import net.minecraft.class_7923;
import net.minecraft.class_897;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryThing<T>
implements Supplier<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(RegistryThing.class);
    public final class_2378<?> registry;
    public final class_2960 rl;

    RegistryThing(class_2378<?> registry, class_2960 rl) {
        this.registry = registry;
        this.rl = rl;
    }

    @Override
    public T get() {
        return (T)this.registry.method_10223(this.rl);
    }

    public class_2960 getId() {
        return this.rl;
    }

    public RegistryThing<T> withItem() {
        return this.withItem(() -> new class_1747((class_2248)this.get(), new class_1792.class_1793()));
    }

    public RegistryThing<T> withItem(Function<class_2248, class_1747> constructor) {
        return this.withItem(() -> (class_1747)constructor.apply((class_2248)this.get()));
    }

    public RegistryThing<T> withItem(Supplier<class_1747> constructor) {
        if (this.registry != class_7923.field_41175) {
            LOGGER.error("Cannot call RegistryThing#withItem for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be block)");
            return this;
        }
        RegistryWrapper.register(class_7923.field_41178, this.rl, constructor);
        return this;
    }

    public RegistryThing<T> withAttributes(Supplier<class_5132.class_5133> builder) {
        if (this.registry != class_7923.field_41177) {
            LOGGER.error("Cannot call RegistryThing#withAttributes for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withAttributes but WrapperLib EntityHelper is missing.");
        }
        EntityHelper.attributes(() -> (class_1299)this.get(), builder);
        return this;
    }

    public <E extends class_1297> RegistryThing<T> withRenderer(Supplier<Function<class_5617.class_5618, class_897<E>>> provider) {
        if (this.registry != class_7923.field_41177) {
            LOGGER.error("Cannot call RegistryThing#withRenderer for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withRenderer but WrapperLib EntityHelper is missing.");
        }
        if (!Available.PLATFORM_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withRenderer but WrapperLib PlatformHelper is missing.");
        }
        if (PlatformHelper.isDedicatedServer()) {
            return this;
        }
        EntityHelper.renderer(() -> (class_1299)this.get(), ctx -> (class_897)((Function)provider.get()).apply(ctx));
        return this;
    }

    public RegistryThing<T> withSpawnEgg(int colourA, int colourB) {
        return this.withSpawnEgg(colourA, colourB, new class_1792.class_1793());
    }

    public RegistryThing<T> withSpawnEgg(int colourA, int colourB, class_1792.class_1793 props) {
        if (this.registry != class_7923.field_41177) {
            LOGGER.error("Cannot call RegistryThing#withSpawnEgg for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withSpawnEgg but WrapperLib EntityHelper is missing.");
        }
        Supplier<class_1792> egg = () -> EntityHelper.getSpawnEggConstructor().create(() -> (class_1299)this.get(), colourA, colourB, props);
        RegistryWrapper.register(class_7923.field_41178, new class_2960(this.rl.method_12836(), this.rl.method_12832() + "_spawn_egg"), egg);
        return this;
    }
}

