/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.config;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import ca.lukegrahamlandry.lib.config.ConfigSyncMessage;
import ca.lukegrahamlandry.lib.config.GenerateComments;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigWrapper<T>
implements Supplier<T> {
    public static MinecraftServer server;
    public static List<ConfigWrapper<?>> ALL;
    public Supplier<T> defaultValue;
    private String name;
    public final Side side;
    public boolean shouldReload = true;
    public Class<T> clazz;
    protected T value;
    private Logger logger;
    private boolean loaded = false;
    private String fileExtension;
    private Gson gson;
    private String subDirectory = null;
    Type actualType;
    private Runnable onLoadAction = () -> {};

    public static <T> ConfigWrapper<T> synced(Class<T> clazz) {
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called ConfigWrapper#synced but WrapperLib Network module is missing.");
        }
        return new ConfigWrapper<T>(clazz, Side.SYNCED);
    }

    public static <T> ConfigWrapper<T> client(Class<T> clazz) {
        return new ConfigWrapper<T>(clazz, Side.CLIENT);
    }

    public static <T> ConfigWrapper<T> server(Class<T> clazz) {
        return new ConfigWrapper<T>(clazz, Side.SERVER);
    }

    public ConfigWrapper<T> named(class_2960 name) {
        this.dir(name.method_12836());
        this.named(name.method_12832());
        return this;
    }

    public ConfigWrapper<T> named(String name) {
        this.name = JsonHelper.safeFileName(name);
        this.createLogger();
        return this;
    }

    public ConfigWrapper<T> dir(String subDirectory) {
        this.subDirectory = JsonHelper.safeFileName(subDirectory);
        this.createLogger();
        return this;
    }

    public ConfigWrapper<T> ext(String fileExtension) {
        this.fileExtension = fileExtension;
        return this;
    }

    public ConfigWrapper<T> noReload() {
        this.shouldReload = false;
        return this;
    }

    public ConfigWrapper<T> withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public <L extends List<T>> ConfigWrapper<L> listOf() {
        ALL.remove(this);
        TypeToken type = TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{this.clazz});
        ConfigWrapper<T> newWrapper = new ConfigWrapper<T>(type, this.side);
        return newWrapper.withSettings(this);
    }

    public <M extends Map<String, T>> ConfigWrapper<M> mapOf() {
        return this.mapOf(String.class);
    }

    public <K, M extends Map<K, T>> ConfigWrapper<M> mapOf(Class<K> keyClass) {
        ALL.remove(this);
        TypeToken type = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{keyClass, this.clazz});
        ConfigWrapper<T> newWrapper = new ConfigWrapper<T>(type, this.side);
        return newWrapper.withSettings(this);
    }

    public ConfigWrapper<T> setDefaultValue(Supplier<T> v) {
        this.defaultValue = v;
        return this;
    }

    public ConfigWrapper<T> onLoad(Runnable action) {
        this.onLoadAction = action;
        return this;
    }

    @Override
    public T get() {
        if (!this.loaded) {
            if (this.side == Side.CLIENT) {
                this.load();
            } else {
                this.logger.info("reading config before calling ConfigWrapper#load, default values will be used for now");
            }
        }
        return this.value;
    }

    public void init() {
    }

    public void sync() {
        if (this.side != Side.SYNCED) {
            this.logger.error("called ConfigWrapper#sync but side=" + this.side + ". Ignoring.");
        } else {
            new ConfigSyncMessage(this).sendToAllClients();
        }
    }

    public void load() {
        if (this.side.inWorldDir && server == null) {
            this.logger.error("cannot load server config before server init. default values will be used for now");
            return;
        }
        if (!Files.exists(this.getFilePath(), new LinkOption[0])) {
            this.writeDefaultFile();
        }
        try {
            BufferedReader reader = Files.newBufferedReader(this.getFilePath());
            this.value = this.getGson().fromJson((Reader)reader, this.actualType);
            ((Reader)reader).close();
            this.logger.info("config loaded from " + this.displayPath());
        }
        catch (IOException e) {
            this.logger.error("failed to load config from " + this.displayPath());
            e.printStackTrace();
        }
        this.loaded = true;
        this.onLoadAction.run();
    }

    private ConfigWrapper(Class<T> clazz, Side side) {
        this(TypeToken.get(clazz), side);
        this.named(ConfigWrapper.defaultName(clazz));
    }

    public ConfigWrapper(TypeToken<T> type, Side side) {
        this.side = side;
        this.fileExtension = "json5";
        this.withGson(JsonHelper.get());
        ALL.add(this);
        this.actualType = type.getType();
        this.clazz = type.getRawType();
        this.defaultValue = this::getDefaultInstance;
        this.value = this.defaultValue.get();
        this.named(type.toString());
    }

    private T getDefaultInstance() {
        try {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error(this.clazz.getName() + " does not have a public parameterless constructor");
            throw new RuntimeException(this.clazz.getName() + " does not have a public parameterless constructor", e);
        }
    }

    private static String defaultName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase(Locale.ROOT).replace("config", "").replace("server", "").replace("client", "");
    }

    void set(Object v) {
        this.value = v;
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void writeDefaultFile() {
        this.getFolderPath().toFile().mkdirs();
        if (this.side.inWorldDir) {
            Path globalDefaultLocation = Paths.get("defaultconfigs", new String[0]);
            if (this.subDirectory != null) {
                globalDefaultLocation = globalDefaultLocation.resolve(this.subDirectory);
            }
            if (Files.exists(globalDefaultLocation = globalDefaultLocation.resolve(this.getFilename()), new LinkOption[0])) {
                try {
                    Files.copy(globalDefaultLocation, this.getFilePath(), StandardCopyOption.REPLACE_EXISTING);
                    this.logger.info("loaded global default config " + globalDefaultLocation.toAbsolutePath().toFile().getCanonicalPath());
                    return;
                }
                catch (IOException e) {
                    this.logger.error("global instance config file existed but could not be copied. generating default");
                    e.printStackTrace();
                }
            }
        }
        try {
            String configData = GenerateComments.commentedJson(this.defaultValue.get(), this.getGson());
            Files.write(this.getFilePath(), configData.getBytes(), new OpenOption[0]);
            this.logger.info("wrote default config to " + this.displayPath());
        }
        catch (IOException e) {
            this.logger.error("failed to write default config to " + this.displayPath());
            e.printStackTrace();
        }
    }

    protected String getFilename() {
        return this.name + "-" + this.side.name().toLowerCase(Locale.ROOT) + "." + this.fileExtension;
    }

    protected Path getFolderPath() {
        Path path = this.side.inWorldDir ? server.method_27050(class_5218.field_24188).resolve("serverconfig") : Paths.get("config", new String[0]);
        if (this.subDirectory != null) {
            path = path.resolve(this.subDirectory);
        }
        return path;
    }

    protected Path getFilePath() {
        return this.getFolderPath().resolve(this.getFilename());
    }

    protected String displayPath() {
        try {
            return this.getFilePath().toAbsolutePath().toFile().getCanonicalPath();
        }
        catch (IOException e) {
            return this.getFilePath().toAbsolutePath().toString();
        }
    }

    public Gson getGson() {
        return this.gson == null ? JsonHelper.get() : this.gson;
    }

    private void createLogger() {
        String id = ConfigWrapper.class.getName() + ": ";
        if (this.getSubDirectory() != null) {
            id = id + this.getSubDirectory() + "/";
        }
        id = id + this.getName() + "-" + this.side.name();
        this.logger = LoggerFactory.getLogger((String)id);
    }

    public String getName() {
        return this.name;
    }

    public String getSubDirectory() {
        return this.subDirectory;
    }

    private ConfigWrapper<T> withSettings(ConfigWrapper<?> other) {
        this.named(other.getName());
        if (other.getSubDirectory() != null) {
            this.dir(other.getSubDirectory());
        }
        this.ext(other.fileExtension);
        this.withGson(other.getGson());
        this.shouldReload = other.shouldReload;
        if (other.clazz == this.clazz) {
            this.setDefaultValue(other.defaultValue);
        }
        return this;
    }

    static {
        ALL = new ArrayList();
    }

    public static enum Side {
        CLIENT(false),
        SYNCED(true),
        SERVER(true);

        public final boolean inWorldDir;

        private Side(boolean perWorld) {
            this.inWorldDir = perWorld;
        }
    }
}

