/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.network;

import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_3222;

public interface ServerSideHandler {
    /**
     * The method to be called when an object of this type is received, through the network, on the server.
     * @param player the player whose client sent the packet
     */
    void handle(class_3222 player);

    // HELPERS

    default void sendToServer(){
        NetworkWrapper.sendToServer(this);
    }

    default class_2596<class_2792> toVanillaServerBound(){
        return (class_2596<class_2792>) NetworkWrapper.toVanillaPacket(this, false);
    }
}
