/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.data.nbt;

import com.google.gson.reflect.TypeToken;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

// TODO: do i need to sync manually?
public class ItemStackDataWrapper<V> extends NbtDataWrapper<class_1799, V> {
    public static final String ID_TAG_KEY = "_id";
    private static final Random rand = new Random();

    public ItemStackDataWrapper(TypeToken<V> valueType) {
        super(valueType);
    }

    protected class_2487 getSharedTag(class_1799 obj){
        if (!obj.method_7985()) obj.method_7980(obj.method_7948());
        class_2487 tag = obj.method_7969();
        if (!tag.method_10545(PARENT_TAG_KEY)) tag.method_10566(PARENT_TAG_KEY, new class_2487());
        return tag.method_10562(PARENT_TAG_KEY);
    }

    @Override
    protected int getHashCode(class_1799 obj) {
        class_2487 tag = getSharedTag(obj);
        if (!tag.method_10545(ID_TAG_KEY)) tag.method_10569(ID_TAG_KEY, rand.nextInt());
        return tag.method_10550(ID_TAG_KEY);
    }
}
