/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.resources;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.resources.DataPackSyncMessage;
import ca.lukegrahamlandry.lib.resources.MergeRule;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ResourcesWrapper<T>
extends class_4080<Map<class_2960, List<JsonElement>>> {
    static MinecraftServer server = null;
    static List<ResourcesWrapper<?>> ALL = new ArrayList();
    TypeToken<T> valueType;
    public final String directory;
    public final boolean isServerSide;
    Map<class_2960, T> data;
    Logger logger;
    protected String suffix = ".json";
    private Gson gson = JsonHelper.get();
    boolean shouldSync = false;
    protected Runnable onLoadAction = () -> {};
    protected MergeRule<T> mergeRule = resources -> resources.get(resources.size() - 1);

    public static <T> ResourcesWrapper<T> data(Class<T> clazz, String directory) {
        return new ResourcesWrapper<T>(TypeToken.get(clazz), directory, true);
    }

    public static <T> ResourcesWrapper<T> assets(Class<T> clazz, String directory) {
        return new ResourcesWrapper<T>(TypeToken.get(clazz), directory, false);
    }

    public ResourcesWrapper<T> mergeWith(MergeRule<T> rule) {
        this.mergeRule = rule;
        return this;
    }

    public ResourcesWrapper<T> onLoad(Runnable action) {
        this.onLoadAction = action;
        return this;
    }

    public ResourcesWrapper<T> synced() {
        if (!this.isServerSide) {
            throw new RuntimeException("ResourcesWrapper#synced may only be called for data packs, NOT resource packs.");
        }
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called ResourcesWrapper#synced but WrapperLib Network module is missing.");
        }
        this.shouldSync = true;
        return this;
    }

    public ResourcesWrapper<T> withGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    public Set<Map.Entry<class_2960, T>> entrySet() {
        return this.data.entrySet();
    }

    public T get(class_2960 id) {
        return this.data.get(id);
    }

    public ResourcesWrapper(TypeToken<T> valueType, String directory, boolean isServerSide) {
        this.valueType = valueType;
        this.directory = directory;
        this.isServerSide = isServerSide;
        if (!this.isServerSide && Available.PLATFORM_HELPER.get() && PlatformHelper.isDedicatedServer()) {
            return;
        }
        ALL.add(this);
        ResourcesWrapper.registerResourceListener(this);
    }

    public Gson getGson() {
        return this.gson;
    }

    protected Map<class_2960, List<JsonElement>> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        HashMap<class_2960, List<JsonElement>> results = new HashMap<class_2960, List<JsonElement>>();
        for (Map.Entry entry : resourceManager.method_41265(this.directory, file -> file.method_12832().endsWith(this.suffix)).entrySet()) {
            String actualPath = ((class_2960)entry.getKey()).method_12832().substring(this.directory.length() + 1, ((class_2960)entry.getKey()).method_12832().length() - this.suffix.length());
            class_2960 id = new class_2960(((class_2960)entry.getKey()).method_12836(), actualPath);
            ArrayList<JsonElement> values = new ArrayList<JsonElement>();
            for (class_3298 resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        values.add((JsonElement)this.getGson().fromJson((Reader)reader, JsonElement.class));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (JsonSyntaxException e) {
                    this.logger.error("Failed to parse json for " + id + " from pack " + resource.method_14480());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    this.logger.error("Failed to read " + id + " from pack " + resource.method_14480());
                    e.printStackTrace();
                }
            }
            if (values.isEmpty()) continue;
            results.put(id, values);
        }
        return results;
    }

    protected void apply(Map<class_2960, List<JsonElement>> resources, class_3300 resourceManager, class_3695 profilerFiller) {
        this.data = new HashMap<class_2960, T>();
        for (Map.Entry<class_2960, List<JsonElement>> entry : resources.entrySet()) {
            class_2960 id = entry.getKey();
            List<JsonElement> resourceStack = entry.getValue();
            ArrayList<Object> values = new ArrayList<Object>();
            for (JsonElement json : resourceStack) {
                values.add(this.getGson().fromJson(json, this.valueType.getType()));
            }
            T finalValue = this.mergeRule.merge(values);
            this.data.put(id, finalValue);
        }
        this.onLoadAction.run();
        if (this.shouldSync && server != null) {
            new DataPackSyncMessage(this).sendToAllClients();
        }
    }

    void set(Object value) {
        this.data = (Map)value;
    }

    @ExpectPlatform
    public static void registerResourceListener(ResourcesWrapper<?> wrapper) {
        throw new AssertionError();
    }
}

