/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.keybind;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_304;

public class KeybindWrapper {
    static Map<String, KeybindWrapper> ALL = new HashMap<String, KeybindWrapper>();
    final String id;
    Consumer<class_1657> onPressAction = p -> {};
    Consumer<class_1657> onReleaseAction = p -> {};
    Consumer<class_1657> onHeldTickAction = p -> {};
    boolean shouldSync = false;
    Map<UUID, Boolean> pressed = new HashMap<UUID, Boolean>();
    class_304 mapping = null;

    public static KeybindWrapper of(String name, String category, int defaultKey) {
        return new KeybindWrapper("key." + category + "." + name, defaultKey, "key.categories." + category);
    }

    public static KeybindWrapper of(String name, String category) {
        return KeybindWrapper.of(name, category, -1);
    }

    public KeybindWrapper synced() {
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called KeybindWrapper#synced but WrapperLib Network module is missing.");
        }
        this.shouldSync = true;
        return this;
    }

    public KeybindWrapper onPress(Consumer<class_1657> action) {
        this.onPressAction = action;
        return this;
    }

    public KeybindWrapper onRelease(Consumer<class_1657> action) {
        this.onReleaseAction = action;
        return this;
    }

    public KeybindWrapper onHeldTick(Consumer<class_1657> action) {
        this.onHeldTickAction = action;
        return this;
    }

    public boolean isPressed(class_1657 player) {
        if (player == null || !player.method_5805()) {
            return false;
        }
        return this.pressed.getOrDefault(player.method_5667(), false);
    }

    public KeybindWrapper(String nameTranslationId, int defaultKey, String categoryTranslationId) {
        this.id = nameTranslationId;
        ALL.put(this.id, this);
        if (!Available.PLATFORM_HELPER.get()) {
            throw new RuntimeException("Tried to create KeybindWrapper but WrapperLib PlatformHelper is missing.");
        }
        if (PlatformHelper.isDedicatedServer()) {
            return;
        }
        this.mapping = new class_304(nameTranslationId, defaultKey, categoryTranslationId);
        KeybindWrapper.register(this.mapping);
    }

    @ExpectPlatform
    public static void register(class_304 key) {
        throw new AssertionError();
    }
}

