/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.config;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import ca.lukegrahamlandry.lib.config.ConfigSyncMessage;
import ca.lukegrahamlandry.lib.config.ConfigWrapper;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class EventCallbacks
implements IEventCallbacks {
    @Override
    public void onServerStarting(MinecraftServer server) {
        ConfigWrapper.server = server;
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side.inWorldDir) {
                config.load();
            }
        });
    }

    @Override
    public void onServerStopped(MinecraftServer server) {
        ConfigWrapper.server = null;
    }

    @Override
    public void onPlayerLoginServer(class_1657 player) {
        if (player.field_6002.method_8608()) {
            return;
        }
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side == ConfigWrapper.Side.SYNCED) {
                new ConfigSyncMessage((ConfigWrapper<?>)config).sendToClient((class_3222)player);
            }
        });
    }

    @Override
    public void onClientSetup() {
        ConfigWrapper.ALL.forEach(config -> {
            if (config.side == ConfigWrapper.Side.CLIENT) {
                config.load();
            }
        });
    }

    public static void onReloadCommand() {
        if (ConfigWrapper.server == null) {
            return;
        }
        ConfigWrapper.ALL.forEach(config -> {
            if (config.shouldReload && config.side.inWorldDir) {
                config.load();
                if (config.side == ConfigWrapper.Side.SYNCED) {
                    config.sync();
                }
            }
        });
    }
}

