/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;

public class RegistryObjectTypeAdapterFactory
implements TypeAdapterFactory {
    public static Map<Class<?>, Adapter<?>> adapters = new HashMap();

    public static void add(Class<?> clazz, Registry<?> registry) {
        adapters.put(clazz, new Adapter(registry));
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        for (Map.Entry<Class<?>, Adapter<?>> entry : adapters.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type.getRawType())) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        RegistryObjectTypeAdapterFactory.add(Item.class, Registry.f_122827_);
        RegistryObjectTypeAdapterFactory.add(Block.class, Registry.f_122824_);
        RegistryObjectTypeAdapterFactory.add(EntityType.class, Registry.f_122826_);
        RegistryObjectTypeAdapterFactory.add(BlockEntityType.class, Registry.f_122830_);
        RegistryObjectTypeAdapterFactory.add(Enchantment.class, Registry.f_122825_);
        RegistryObjectTypeAdapterFactory.add(MobEffect.class, Registry.f_122823_);
        RegistryObjectTypeAdapterFactory.add(Fluid.class, Registry.f_122822_);
        RegistryObjectTypeAdapterFactory.add(Potion.class, Registry.f_122828_);
    }

    private static class Adapter<T>
    extends TypeAdapter<T> {
        private final Registry<T> registry;

        public Adapter(Registry<T> registry) {
            this.registry = registry;
        }

        public void write(JsonWriter out, T value) throws IOException {
            ResourceLocation rl = this.registry.m_7981_(value);
            out.value(rl.toString());
        }

        public T read(JsonReader in) throws IOException {
            String rl = in.nextString();
            return (T)this.registry.m_7745_(new ResourceLocation(rl));
        }
    }
}

