/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackTypeAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public ItemStack deserialize(JsonElement data, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject json = data.getAsJsonObject();
        ResourceLocation itemKey = new ResourceLocation(json.get("item").getAsString());
        Item item = (Item)Registry.f_122827_.m_7745_(itemKey);
        int count = json.get("count").getAsInt();
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (json.has("tag")) {
            CompoundTag tag = (CompoundTag)ctx.deserialize(json.get("tag"), CompoundTag.class);
            stack.m_41751_(tag);
        }
        return stack;
    }

    public JsonElement serialize(ItemStack obj, Type type, JsonSerializationContext ctx) {
        JsonObject out = new JsonObject();
        out.addProperty("item", Registry.f_122827_.m_7981_((Object)obj.m_41720_()).toString());
        out.addProperty("count", (Number)obj.m_41613_());
        if (obj.m_41782_()) {
            out.add("tag", ctx.serialize((Object)obj.m_41783_()));
        }
        return out;
    }
}

