/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.resources;

import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import ca.lukegrahamlandry.lib.resources.ResourcesWrapper;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPackSyncMessage
implements ClientSideHandler {
    static Logger LOGGER = LoggerFactory.getLogger(DataPackSyncMessage.class);
    String value;
    String directory;

    public DataPackSyncMessage(ResourcesWrapper<?> wrapper) {
        this.directory = wrapper.directory;
        this.value = wrapper.getGson().toJson(wrapper.data);
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (ResourcesWrapper<?> resources : ResourcesWrapper.ALL) {
            if (!resources.isServerSide || !resources.shouldSync || !Objects.equals(this.directory, resources.directory)) continue;
            try {
                Type target = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{class_2960.class, resources.valueType.getRawType()}).getType();
                Map syncedValue = (Map)resources.getGson().fromJson(this.value, target);
                resources.set(syncedValue);
            }
            catch (JsonSyntaxException e) {
                LOGGER.error("Failed to parse synced data resources " + this.directory + " to Map: ResourceLocation->" + resources.valueType.getType().getTypeName());
                LOGGER.error("data: " + this.value);
                e.printStackTrace();
            }
            handled = true;
        }
        if (!handled) {
            LOGGER.error("Received data pack sync for unknown {dir: " + this.directory + "}");
        }
    }
}

