/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.file.LazyFileHandler;
import ca.lukegrahamlandry.lib.data.impl.file.MapFileHandler;
import ca.lukegrahamlandry.lib.data.impl.file.SingleFileHandler;
import ca.lukegrahamlandry.lib.data.impl.file.SplitFileHandler;
import ca.lukegrahamlandry.lib.data.sync.FullMapDataSyncMessage;
import ca.lukegrahamlandry.lib.data.sync.SingleEntryMapDataSyncMessage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class MapDataWrapper<K, I, V>
extends DataWrapper<V> {
    public Map<I, V> data = new HashMap<I, V>();
    private final Class<I> idClazz;
    private MapFileHandler<K, I, V> fileHandler;
    private boolean shouldLazyLoad = false;
    private Set<I> dirtyEntries = new HashSet<I>();

    public <W extends MapDataWrapper<K, I, V>> W splitFiles() {
        if (!this.shouldLazyLoad) {
            this.fileHandler = new SplitFileHandler(this);
        }
        return (W)this;
    }

    public <W extends MapDataWrapper<K, I, V>> W lazy() {
        this.fileHandler = new LazyFileHandler(this);
        this.shouldLazyLoad = true;
        return (W)this;
    }

    public V get(K key) {
        return this.getById(this.keyToId(key));
    }

    public void setDirty(K key) {
        this.isDirty = true;
        this.dirtyEntries.add(this.keyToId(key));
        if (this.shouldSync) {
            this.sync(key);
        }
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.dirtyEntries.addAll(this.data.keySet());
    }

    public void remove(K key) {
        this.data.remove(this.keyToId(key));
        this.fileHandler.clear(this.keyToId(key));
        this.setDirty(key);
        this.dirtyEntries.remove(this.keyToId(key));
    }

    protected MapDataWrapper(Class<I> idClazz, Class<V> clazz) {
        super(clazz);
        this.idClazz = idClazz;
        this.fileHandler = new SingleFileHandler(this);
    }

    public abstract I keyToId(K var1);

    public abstract I stringToId(String var1);

    public V getById(I id) {
        if (!this.isLoaded) {
            this.logger.error("cannot call DataWrapper get (a) before server startup (b) on client if unsynced (c) on client before sync");
            return null;
        }
        if (!this.data.containsKey(id)) {
            if (this.shouldLazyLoad) {
                ((LazyFileHandler)this.fileHandler).load(id);
            }
            if (!this.data.containsKey(id)) {
                this.data.put(id, this.createDefaultInstance());
            }
        }
        return this.data.get(id);
    }

    @Override
    public void save() {
        if (server == null) {
            String msg = "cannot call DataWrapper#save (a) after server shutdown (b) on client";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        this.fileHandler.save();
    }

    @Override
    public void load() {
        if (server == null) {
            String msg = "cannot call DataWrapper#load (a) before server startup (b) on client";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        this.fileHandler.load();
        this.isLoaded = true;
    }

    @Override
    public void sync() {
        if (!this.shouldSync) {
            this.logger.error("called DataWrapper#sync but shouldSync=false");
        } else {
            new FullMapDataSyncMessage(this).sendToAllClients();
        }
    }

    public void sync(K key) {
        if (!this.shouldSync) {
            this.logger.error("called DataWrapper#sync but shouldSync=false");
        } else {
            new SingleEntryMapDataSyncMessage(this, this.keyToId(key)).sendToAllClients();
        }
    }

    public boolean isDirty(I id) {
        return this.dirtyEntries.contains(id);
    }

    public void loadFromMap(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            try {
                I id = this.stringToId((String)entry.getKey());
                Object value = this.getGson().fromJson((JsonElement)entry.getValue(), this.clazz);
                this.data.put(id, value);
            }
            catch (JsonSyntaxException e) {
                this.logger.error("Ignoring key " + (String)entry.getKey() + "; Failed to parse json data: " + entry.getValue());
                e.printStackTrace();
            }
        }
        this.isLoaded = true;
    }

    public void set(Object id, Object value) {
        this.data.put(id, value);
        this.isLoaded = true;
    }

    public Map<I, V> getMap() {
        return this.data;
    }
}

