/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.registry;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.helper.EntityHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5617;
import net.minecraft.class_897;

/**
 * @param <T> the type of object that we are
 */
public class RegistryThing<T> implements Supplier<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(RegistryThing.class);
    public final class_2378<?> registry;
    public final class_2960 rl;

    RegistryThing(class_2378<?> registry, class_2960 rl){
        this.registry = registry;
        this.rl = rl;
    }

    @Override
    public T get() {
        return (T) this.registry.method_10223(rl);
    }

    public class_2960 getId() {
        return this.rl;
    }

    // HELPERS

    /**
     * Creates a BlockItem for your Block.
     */
    public RegistryThing<T> withItem(){
        return this.withItem(() -> new class_1747((class_2248) this.get(), new class_1792.class_1793().method_7892(class_1761.field_7931)));
    }

    /**
     * Creates a BlockItem for your Block.
     */
    public RegistryThing<T> withItem(Function<class_2248, class_1747> constructor){
        return this.withItem(() -> constructor.apply((class_2248) this.get()));
    }

    /**
     * Creates a BlockItem for your Block.
     */
    public RegistryThing<T> withItem(Supplier<class_1747> constructor){
        if (this.registry != class_2378.field_11146){
            LOGGER.error("Cannot call RegistryThing#withItem for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be block)");
            return this;
        }
        RegistryWrapper.register(class_2378.field_11142, this.rl, constructor);
        return this;
    }

    /**
     * Binds attributes to your EntityType. May only be called if the entity extends LivingEntity.
     */
    public RegistryThing<T> withAttributes(Supplier<class_5132.class_5133> builder){
        if (this.registry != class_2378.field_11145){
            LOGGER.error("Cannot call RegistryThing#withAttributes for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) throw new RuntimeException("Called RegistryThing#withAttributes but WrapperLib EntityHelper is missing.");

        EntityHelper.attributes(() -> (class_1299<? extends class_1309>) this.get(), builder);
        return this;
    }

    // https://www.youtube.com/watch?v=tXCuV_9naVI
    /**
     * Binds a renderer to your EntityType.
     * This can safely be called on the dedicated server because it checks before actually calling your supplier (and thus class loading the renderer).
     * @param provider {@code Supplier<EntityRendererProvider<O>>}, a supplier for your EntityRenderer constructor
     * @param <E> the type of entity we are
     */
    public <E extends class_1297> RegistryThing<T> withRenderer(Supplier<Function<class_5617.class_5618, class_897<E>>> provider){
        if (this.registry != class_2378.field_11145){
            LOGGER.error("Cannot call RegistryThing#withRenderer for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) throw new RuntimeException("Called RegistryThing#withRenderer but WrapperLib EntityHelper is missing.");
        if (!Available.PLATFORM_HELPER.get()) throw new RuntimeException("Called RegistryThing#withRenderer but WrapperLib PlatformHelper is missing.");

        if (PlatformHelper.isDedicatedServer()) return this;
        EntityHelper.renderer(() -> (class_1299<? extends E>) this.get(), (ctx) -> provider.get().apply(ctx));
        return this;
    }

    /**
     * Creates a SpawnEggItem for your EntityType. May only be called if the entity extends Mob.
     */
    public RegistryThing<T> withSpawnEgg(int colourA, int colourB){
        return withSpawnEgg(colourA, colourB, new class_1792.class_1793().method_7892(class_1761.field_7932));
    }

    /**
     * Creates a SpawnEggItem for your EntityType. May only be called if the entity extends Mob.
     */
    public RegistryThing<T> withSpawnEgg(int colourA, int colourB, class_1792.class_1793 props){
        if (this.registry != class_2378.field_11145){
            LOGGER.error("Cannot call RegistryThing#withSpawnEgg for " + this.rl + " (" + this.registry.method_30517().method_29177().method_12832() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) throw new RuntimeException("Called RegistryThing#withSpawnEgg but WrapperLib EntityHelper is missing.");

        Supplier<class_1792> egg = () -> EntityHelper.getSpawnEggConstructor().create(() -> (class_1299<? extends class_1308>) this.get(), colourA, colourB, props);
        RegistryWrapper.register(class_2378.field_11142, new class_2960(this.rl.method_12836(), this.rl.method_12832() + "_spawn_egg"), egg);
        return this;
    }
}
