/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.keybind;

import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class KeybindTickCallbacks {
    public static void onClientTick(){
        class_1657 player = class_310.method_1551().field_1724;
        if (player == null) return;

        for (KeybindWrapper key : KeybindWrapper.ALL.values()){
            boolean wasDown = key.isPressed(player);
            if (key.mapping.method_1434()){
                if (!wasDown){
                    key.pressed.put(player.method_5667(), true);
                    key.onPressAction.accept(player);
                    if (key.shouldSync) new KeyStateMessage(key).sendToServer();
                }
                key.onHeldTickAction.accept(player);
            } else if (wasDown) {
                key.pressed.put(player.method_5667(), false);
                key.onReleaseAction.accept(player);
                if (key.shouldSync) new KeyStateMessage(key).sendToServer();
            }
        }
    }

    public static void onServerPlayerTick(class_3222 player){
        for (KeybindWrapper key : KeybindWrapper.ALL.values()){
            if (key.isPressed(player)){
                key.onHeldTickAction.accept(player);
            }
        }
    }
}
