/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.*;
import java.lang.reflect.Type;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class ItemStackTypeAdapter implements JsonDeserializer<class_1799>, JsonSerializer<class_1799> {
    public ItemStackTypeAdapter() {
    }

    public class_1799 deserialize(JsonElement data, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject json = data.getAsJsonObject();
        class_2960 itemKey = new class_2960(json.get("item").getAsString());
        class_1792 item = class_2378.field_11142.method_10223(itemKey);
        int count = json.get("count").getAsInt();

        class_1799 stack = new class_1799(item, count);

        if (json.has("tag")){
            class_2487 tag = ctx.deserialize(json.get("tag"), class_2487.class);
            stack.method_7980(tag);
        }

        return stack;
    }

    public JsonElement serialize(class_1799 obj, Type type, JsonSerializationContext ctx) {
        JsonObject out = new JsonObject();
        out.addProperty("item", class_2378.field_11142.method_10221(obj.method_7909()).toString());
        out.addProperty("count", obj.method_7947());
        if (obj.method_7985()) out.add("tag", ctx.serialize(obj.method_7969()));
        return out;
    }
}