/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_2338;

public class BlockPosTypeAdapter implements JsonDeserializer<class_2338>, JsonSerializer<class_2338> {
    public BlockPosTypeAdapter() {
    }

    public class_2338 deserialize(JsonElement data, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        String values = data.getAsString();
        String[] parts = values.split(",");
        return new class_2338(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    public JsonElement serialize(class_2338 obj, Type type, JsonSerializationContext ctx) {
        String values = obj.method_10263() + "," + obj.method_10264() + "," + obj.method_10260();
        return new JsonPrimitive(values);
    }
}