/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl.file;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.file.MapFileHandler;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.class_5218;

public class SingleFileHandler<K, I, V>
implements MapFileHandler {
    private final MapDataWrapper<K, I, V> wrapper;

    public SingleFileHandler(MapDataWrapper<K, I, V> wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void save() {
        Gson pretty = this.wrapper.getGson().newBuilder().setPrettyPrinting().create();
        this.getFilePath().toFile().getParentFile().mkdirs();
        String json = pretty.toJson(this.wrapper.data);
        try {
            Files.write(this.getFilePath(), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.wrapper.logger.error("failed to write data to " + DataWrapper.forDisplay(this.getFilePath()));
        }
    }

    @Override
    public void load() {
        if (!this.getFilePath().toFile().exists()) {
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(this.getFilePath());
            JsonObject fileInfo = (JsonObject)this.wrapper.getGson().fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            this.wrapper.loadFromMap(fileInfo);
        }
        catch (JsonSyntaxException | IOException e) {
            String msg = "failed to load data from " + DataWrapper.forDisplay(this.getFilePath());
            this.wrapper.logger.error(msg);
            e.printStackTrace();
        }
    }

    public Path getFilePath() {
        Path path = DataWrapper.server.method_27050(class_5218.field_24188).resolve("data");
        if (this.wrapper.getSubDirectory() != null) {
            path = path.resolve(this.wrapper.getSubDirectory());
        }
        path = path.resolve(this.wrapper.getName() + "." + this.wrapper.fileExtension);
        return path;
    }
}

