/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class NbtTypeAdapter implements JsonDeserializer<class_2487>, JsonSerializer<class_2487> {
    public NbtTypeAdapter() {
    }

    public class_2487 deserialize(JsonElement data, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        try {
            return class_2522.method_10718(data.getAsString());
        } catch (CommandSyntaxException e) {
            throw new JsonParseException(e);
        }
    }

    public JsonElement serialize(class_2487 obj, Type type, JsonSerializationContext ctx) {
        return new JsonPrimitive(obj.method_10714());
    }
}