/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import ca.lukegrahamlandry.lib.network.NetworkWrapper;
import ca.lukegrahamlandry.lib.network.ServerSideHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class HandshakeHelper
implements IEventCallbacks {
    private static final HashMap<String, ModProtocol> ACTIVE_VERSIONS = new HashMap();
    public static final HashMap<String, Predicate<String>> CLIENT_VERSION_CHECKERS = new HashMap();
    public static final HashMap<String, Predicate<String>> SERVER_VERSION_CHECKERS = new HashMap();

    public static void add(ModProtocol protocol) {
        ACTIVE_VERSIONS.put(protocol.modid, protocol);
    }

    private static void logProtocolVersions() {
        StringBuilder debug = new StringBuilder();
        for (ModProtocol protocol : ACTIVE_VERSIONS.values()) {
            debug.append(protocol).append(" ");
        }
        if (!debug.isEmpty()) {
            NetworkWrapper.LOGGER.info("Mod Protocol Versions: " + debug);
        }
    }

    @Override
    public void onPlayerLoginServer(class_1657 player) {
        new HandshakeMessage(ACTIVE_VERSIONS.values()).sendToClient((class_3222)player);
    }

    @Override
    public void onClientSetup() {
        HandshakeHelper.logProtocolVersions();
    }

    @Override
    public void onServerStarting(MinecraftServer server) {
        HandshakeHelper.logProtocolVersions();
    }

    public static class ModProtocol {
        String modid;
        String version;

        public ModProtocol(String modid, String version) {
            this.modid = modid;
            this.version = version;
        }

        public String toString() {
            return "(" + this.modid + ", " + this.version + ")";
        }
    }

    private static class HandshakeMessage
    implements ServerSideHandler,
    ClientSideHandler {
        public List<ModProtocol> mods;

        public HandshakeMessage(Collection<ModProtocol> mods) {
            this.mods = new ArrayList<ModProtocol>(mods);
        }

        @Override
        public void handle() {
            boolean accepted = this.validate(CLIENT_VERSION_CHECKERS, msg -> class_310.method_1551().field_1724.field_3944.method_2872().method_10747(msg), "client");
            if (accepted) {
                NetworkWrapper.LOGGER.info("client accepts server's mod protocol versions");
                new HandshakeMessage(ACTIVE_VERSIONS.values()).sendToServer();
            }
        }

        @Override
        public void handle(class_3222 player) {
            this.validate(SERVER_VERSION_CHECKERS, msg -> player.field_13987.method_14367(msg), "server");
        }

        private boolean validate(HashMap<String, Predicate<String>> sidedVersionCheckers, Consumer<class_2561> sendDisconnect, String side) {
            for (ModProtocol protocol : this.mods) {
                boolean accepted;
                String otherSideVersion = protocol.version;
                try {
                    accepted = sidedVersionCheckers.getOrDefault(protocol.modid, s -> true).test(otherSideVersion);
                }
                catch (Exception e) {
                    accepted = false;
                }
                if (accepted) continue;
                sendDisconnect.accept(HandshakeMessage.error(protocol, side));
                return false;
            }
            return true;
        }

        private static class_2561 error(ModProtocol protocol, String side) {
            String currentSideVersion = ACTIVE_VERSIONS.containsKey(protocol.modid) ? HandshakeHelper.ACTIVE_VERSIONS.get((Object)protocol.modid).version : "NONE";
            String otherSide = side.equals("server") ? "client" : "server";
            String v = protocol.modid + "'s active protocol versions are (" + side + ": " + currentSideVersion + ", " + otherSide + ": " + protocol.version + ")";
            NetworkWrapper.LOGGER.info(v);
            return class_2561.method_43470((String)("Mod (" + protocol.modid + ") network protocol not accepted by " + side + ". Ensure client and server have same mod version. " + v));
        }
    }
}

