/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.json;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class JsonHelper {
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder().setLenient()
            .registerTypeAdapter(class_2960.class, new class_2960.class_2961())
            .registerTypeAdapter(GenericHolder.class, new GenericHolder.TypeAdapter())
            .registerTypeAdapter(class_2487.class, new NbtTypeAdapter())
            .registerTypeAdapter(class_1799.class, new ItemStackTypeAdapter())
            .registerTypeAdapterFactory(new RegistryObjectTypeAdapterFactory());

    private static Gson GSON = GSON_BUILDER.create();

    public static Gson get(){
        return GSON;
    }

    /**
     * When not shadowing, please prefer using ConfigWrapper#withGson or DataWrapper#withGson because that will ensure you do not conflict with other mods.
     * @param type the type of object that needs custom serialization handling
     * @param typeAdapter the type adapter that will handle serialization (instanceof TypeAdapter, JsonSerializer, JsonDeserializer, or InstanceCreator)
     */
    public static void addTypeAdapter(Type type, Object typeAdapter){
        GSON_BUILDER.registerTypeAdapter(type, typeAdapter);
        init();
    }

    /**
     * When not shadowing, please prefer using ConfigWrapper#withGson or DataWrapper#withGson because that will ensure you do not conflict with other mods.
     */
    public static void addTypeAdapterFactory(TypeAdapterFactory factory){
        GSON_BUILDER.registerTypeAdapterFactory(factory);
        init();
    }

    private static void init(){
        GSON = GSON_BUILDER.create();
    }

    public static String safeFileName(String s){
        return s.toLowerCase(Locale.ROOT)
                .replace(":", "-")
                .replace(" ", "-");
    }
}
