/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.network;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public class EfficientNetworkSerializer {
    private static void recurseEncode(FriendlyByteBuf buffer, JsonElement data) {
        if (data.isJsonObject()) {
            JsonObject obj = data.getAsJsonObject();
            ArrayList keys = new ArrayList(obj.keySet());
            buffer.writeInt(keys.size());
            Collections.sort(keys);
            for (String key : keys) {
                EfficientNetworkSerializer.recurseEncode(buffer, obj.get(key));
            }
        } else if (data.isJsonArray()) {
            JsonArray array = data.getAsJsonArray();
            buffer.writeInt(array.size());
            for (JsonElement entry : array) {
                EfficientNetworkSerializer.recurseEncode(buffer, entry);
            }
        } else if (!data.isJsonPrimitive()) {
            if (((JsonPrimitive)data).isString()) {
                buffer.m_130072_(data.getAsString(), GenericHolder.NETWORK_MAX_CHARS);
            } else {
                buffer.m_130072_(data.toString(), GenericHolder.NETWORK_MAX_CHARS);
            }
        }
    }

    private static JsonElement recurseDecode(FriendlyByteBuf buffer, Class<?> clazz) {
        String string;
        int i;
        int length;
        if (clazz == String.class || clazz.isPrimitive()) {
            return (JsonElement)JsonHelper.get().fromJson(buffer.m_130277_(), JsonElement.class);
        }
        if (clazz.isArray()) {
            length = buffer.readInt();
            for (i = 0; i < length; ++i) {
                string = buffer.m_130136_(GenericHolder.NETWORK_MAX_CHARS);
            }
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            length = buffer.readInt();
            for (i = 0; i < length; ++i) {
                string = buffer.m_130136_(GenericHolder.NETWORK_MAX_CHARS);
            }
        }
        if (Map.class.isAssignableFrom(clazz)) {
            length = buffer.readInt();
            for (i = 0; i < length; ++i) {
                int n = buffer.readInt();
            }
        }
        return null;
    }
}

