/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.keybind;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.keybind.forge.KeybindWrapperImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.world.entity.player.Player;

public class KeybindWrapper {
    static Map<String, KeybindWrapper> ALL = new HashMap<String, KeybindWrapper>();
    final String id;
    Consumer<Player> onPressAction = p -> {};
    Consumer<Player> onReleaseAction = p -> {};
    Consumer<Player> onHeldTickAction = p -> {};
    boolean shouldSync = false;
    Map<UUID, Boolean> pressed = new HashMap<UUID, Boolean>();
    KeyMapping mapping = null;

    public static KeybindWrapper of(String name, String category, int defaultKey) {
        return new KeybindWrapper("key." + category + "." + name, defaultKey, "key.categories." + category);
    }

    public static KeybindWrapper of(String name, String category) {
        return KeybindWrapper.of(name, category, -1);
    }

    public KeybindWrapper synced() {
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called KeybindWrapper#synced but WrapperLib Network module is missing.");
        }
        this.shouldSync = true;
        return this;
    }

    public KeybindWrapper onPress(Consumer<Player> action) {
        this.onPressAction = action;
        return this;
    }

    public KeybindWrapper onRelease(Consumer<Player> action) {
        this.onReleaseAction = action;
        return this;
    }

    public KeybindWrapper onHeldTick(Consumer<Player> action) {
        this.onHeldTickAction = action;
        return this;
    }

    public boolean isPressed(Player player) {
        if (player == null || !player.m_6084_()) {
            return false;
        }
        return this.pressed.getOrDefault(player.m_142081_(), false);
    }

    public KeybindWrapper(String nameTranslationId, int defaultKey, String categoryTranslationId) {
        this.id = nameTranslationId;
        ALL.put(this.id, this);
        if (!Available.PLATFORM_HELPER.get()) {
            throw new RuntimeException("Tried to create KeybindWrapper but WrapperLib PlatformHelper is missing.");
        }
        if (PlatformHelper.isDedicatedServer()) {
            return;
        }
        this.mapping = new KeyMapping(nameTranslationId, defaultKey, categoryTranslationId);
        KeybindWrapper.register(this.mapping);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void register(KeyMapping key) {
        KeybindWrapperImpl.register(key);
    }
}

