/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.registry.forge;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.DeferredRegister;

public class RegistryWrapperImpl {
    public static <T> void register(Registry<T> registry, ResourceLocation rl, Supplier<? extends T> constructor) {
        RegistryContainer.of(registry, (String)rl.m_135827_()).deferred.register(rl.m_135815_(), constructor);
    }

    private static class RegistryContainer<T> {
        final DeferredRegister<T> deferred;
        final String modid;
        private static final Map<String, RegistryContainer<?>> registries = new HashMap();

        private RegistryContainer(Registry<T> registry, String modid) {
            this.modid = modid;
            this.deferred = DeferredRegister.create((ResourceKey)registry.m_123023_(), (String)modid);
            this.deferred.register(this.getModEventBus());
        }

        private static <T> RegistryContainer<T> of(Registry<T> registry, String modid) {
            String descriptor = modid + "-" + registry.m_123023_().m_135782_();
            if (!registries.containsKey(descriptor)) {
                registries.put(descriptor, new RegistryContainer<T>(registry, modid));
            }
            return registries.get(descriptor);
        }

        private IEventBus getModEventBus() {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            Optional parentMod = ModList.get().getModContainerById(this.modid);
            if (parentMod.isPresent() && parentMod.get() instanceof FMLModContainer) {
                bus = ((FMLModContainer)parentMod.get()).getEventBus();
            }
            return bus;
        }
    }
}

