/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.registry;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.helper.EntityHelper;
import ca.lukegrahamlandry.lib.helper.PlatformHelper;
import ca.lukegrahamlandry.lib.registry.RegistryWrapper;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryThing<T>
implements Supplier<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(RegistryThing.class);
    public final Registry<?> registry;
    public final ResourceLocation rl;

    RegistryThing(Registry<?> registry, ResourceLocation rl) {
        this.registry = registry;
        this.rl = rl;
    }

    @Override
    public T get() {
        return (T)this.registry.m_7745_(this.rl);
    }

    public ResourceLocation getId() {
        return this.rl;
    }

    public RegistryThing<T> withItem() {
        return this.withItem(() -> new BlockItem((Block)this.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40749_)));
    }

    public RegistryThing<T> withItem(Function<Block, BlockItem> constructor) {
        return this.withItem(() -> (BlockItem)constructor.apply((Block)this.get()));
    }

    public RegistryThing<T> withItem(Supplier<BlockItem> constructor) {
        if (this.registry != Registry.f_122824_) {
            LOGGER.error("Cannot call RegistryThing#withItem for " + this.rl + " (" + this.registry.m_123023_().m_135782_().m_135815_() + ", should be block)");
            return this;
        }
        RegistryWrapper.register(Registry.f_122827_, this.rl, constructor);
        return this;
    }

    public RegistryThing<T> withAttributes(Supplier<AttributeSupplier.Builder> builder) {
        if (this.registry != Registry.f_122826_) {
            LOGGER.error("Cannot call RegistryThing#withAttributes for " + this.rl + " (" + this.registry.m_123023_().m_135782_().m_135815_() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withAttributes but WrapperLib EntityHelper is missing.");
        }
        EntityHelper.attributes(() -> (EntityType)this.get(), builder);
        return this;
    }

    public <E extends Entity> RegistryThing<T> withRenderer(Supplier<Function<EntityRendererProvider.Context, EntityRenderer<E>>> provider) {
        if (this.registry != Registry.f_122826_) {
            LOGGER.error("Cannot call RegistryThing#withRenderer for " + this.rl + " (" + this.registry.m_123023_().m_135782_().m_135815_() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withRenderer but WrapperLib EntityHelper is missing.");
        }
        if (PlatformHelper.isDedicatedServer()) {
            return this;
        }
        EntityHelper.renderer(() -> (EntityType)this.get(), ctx -> (EntityRenderer)((Function)provider.get()).apply(ctx));
        return this;
    }

    public RegistryThing<T> withSpawnEgg(int colourA, int colourB) {
        return this.withSpawnEgg(colourA, colourB, new Item.Properties().m_41491_(CreativeModeTab.f_40753_));
    }

    public RegistryThing<T> withSpawnEgg(int colourA, int colourB, Item.Properties props) {
        if (this.registry != Registry.f_122826_) {
            LOGGER.error("Cannot call RegistryThing#withSpawnEgg for " + this.rl + " (" + this.registry.m_123023_().m_135782_().m_135815_() + ", should be entity type)");
            return this;
        }
        if (!Available.ENTITY_HELPER.get()) {
            throw new RuntimeException("Called RegistryThing#withSpawnEgg but WrapperLib EntityHelper is missing.");
        }
        Supplier<Item> egg = () -> EntityHelper.getSpawnEggConstructor().create(() -> (EntityType)this.get(), colourA, colourB, props);
        RegistryWrapper.register(Registry.f_122827_, new ResourceLocation(this.rl.m_135827_(), this.rl.m_135815_() + "_spawn_egg"), egg);
        return this;
    }
}

