/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.sync;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import com.google.gson.JsonObject;
import java.util.Objects;

public class SplitMapDataSyncMessage
implements ClientSideHandler {
    String value;
    String name;
    String dir;

    public SplitMapDataSyncMessage(MapDataWrapper<?, ?, ?> wrapper) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.value = wrapper.getGson().toJson(wrapper.getMap());
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (DataWrapper<?> data : DataWrapper.ALL) {
            if (!(data instanceof MapDataWrapper) || !Objects.equals(this.dir, data.getSubDirectory()) || !data.getName().equals(this.name)) continue;
            JsonObject syncedValue = (JsonObject)data.getGson().fromJson(this.value, JsonObject.class);
            ((MapDataWrapper)data).loadFromMap(syncedValue);
            handled = true;
        }
        if (!handled) {
            DataWrapper.LOGGER.error("SplitMap. Received data sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
        }
    }
}

