/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.file.MapFileHandler;
import ca.lukegrahamlandry.lib.data.impl.file.SingleFileHandler;
import ca.lukegrahamlandry.lib.data.impl.file.SplitFileHandler;
import ca.lukegrahamlandry.lib.data.sync.SingleMapDataSyncMessage;
import ca.lukegrahamlandry.lib.data.sync.SplitMapDataSyncMessage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;

public abstract class MapDataWrapper<K, I, V>
extends DataWrapper<V> {
    public Map<I, V> data = new HashMap<I, V>();
    private final Class<I> idClazz;
    private MapFileHandler fileHandler;

    public <W extends MapDataWrapper<K, I, V>> W splitFiles() {
        this.fileHandler = new SplitFileHandler(this);
        return (W)this;
    }

    public V get(K key) {
        return this.getById(this.keyToId(key));
    }

    public void setDirty(K key) {
        this.isDirty = true;
        if (this.shouldSync) {
            this.sync(key);
        }
    }

    public void clear(K key) {
        this.data.remove(this.keyToId(key));
        this.setDirty(key);
    }

    protected MapDataWrapper(Class<I> idClazz, Class<V> clazz) {
        super(clazz);
        this.idClazz = idClazz;
        this.fileHandler = new SingleFileHandler(this);
    }

    public abstract I keyToId(K var1);

    public abstract I stringToId(String var1);

    public V getById(I id) {
        if (!this.isLoaded) {
            this.logger.error("cannot call DataWrapper get (a) before server startup (b) on client if unsynced");
            return null;
        }
        if (!this.data.containsKey(id)) {
            this.data.put(id, this.createDefaultInstance());
        }
        return this.data.get(id);
    }

    @Override
    public void save() {
        this.fileHandler.save();
    }

    @Override
    public void load() {
        if (server == null) {
            String msg = "cannot call DataWrapper#load (a) before server startup (b) on client";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        this.fileHandler.load();
        this.isLoaded = true;
    }

    public void loadFromMap(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            try {
                I id = this.stringToId((String)entry.getKey());
                Object value = this.getGson().fromJson((JsonElement)entry.getValue(), this.clazz);
                this.data.put(id, value);
            }
            catch (JsonSyntaxException e) {
                this.logger.error("Ignoring key " + (String)entry.getKey() + "; Failed to parse json data: " + entry.getValue());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sync() {
        if (!this.shouldSync) {
            this.logger.error("called DataWrapper#sync but shouldSync=false");
            return;
        }
        new SplitMapDataSyncMessage(this).sendToAllClients();
    }

    public void sync(K key) {
        if (!this.shouldSync) {
            this.logger.error("called DataWrapper#sync but shouldSync=false");
            return;
        }
        new SingleMapDataSyncMessage(this, this.keyToId(key)).sendToAllClients();
    }

    public void set(Object id, Object value) {
        this.data.put(id, value);
    }

    public Map<I, V> getMap() {
        return this.data;
    }
}

