/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.data.sync;

import ca.lukegrahamlandry.lib.base.WorkInProgress;
import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.TileFileDataWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

@WorkInProgress
public class TileFileDataMessage implements ClientSideHandler {
    String value;
    class_2338 pos;
    class_2960 dimension;
    String name;
    String dir;

    public <T> TileFileDataMessage(TileFileDataWrapper<T> wrapper, class_2586 tile) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.pos = tile.method_11016();
        this.dimension = tile.method_10997().method_27983().method_29177();

        // encode here using ConfigWrapper#getGson instead of allowing the object to be encoded by the packet module's gson instance
        // this allows adding type adapters to your ConfigWrapper and still having syncing
        // TODO: since not using a GenericHolder, data may not be a subclass of V
        this.value = wrapper.getGson().toJson(wrapper.get(tile));
    }

    public void handle() {
        boolean handled = false;
        for (DataWrapper<?> data : DataWrapper.ALL) {
            if (data instanceof TileFileDataWrapper<?> && Objects.equals(this.dir, data.getSubDirectory()) && data.getName().equals(this.name)) {
                Object syncedValue = data.getGson().fromJson(this.value, data.clazz);
                ((TileFileDataWrapper<?>) data).set(dimension, pos, syncedValue);
            }
        }

        if (!handled) DataWrapper.LOGGER.error("SingleMap. Received data sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
    }
}
