/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.base.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class RegistryObjectTypeAdapterFactory implements TypeAdapterFactory {
    public static Map<Class<?>, Adapter<?>> adapters = new HashMap<>();

    public static void add(Class<?> clazz, class_2378<?> registry){
        adapters.put(clazz, new Adapter<>(registry));
    }

    static {
        add(class_1792.class, class_2378.field_11142);
        add(class_2248.class, class_2378.field_11146);
        add(class_1299.class, class_2378.field_11145);
        add(class_2591.class, class_2378.field_11137);
        add(class_1887.class, class_2378.field_11160);
        add(class_1291.class, class_2378.field_11159);
        add(class_3611.class, class_2378.field_11154);
        add(class_1842.class, class_2378.field_11143);
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        for (Map.Entry<Class<?>, Adapter<?>> entry : adapters.entrySet()){
            if (entry.getKey().isAssignableFrom(type.getRawType())) return (TypeAdapter<T>) entry.getValue();
        }

        return null;
    }

    private static class Adapter<T> extends TypeAdapter<T> {
        private final class_2378<T> registry;

        public Adapter(class_2378<T> registry){
            this.registry = registry;
        }
        @Override
        public void write(JsonWriter out, T value) throws IOException {
            class_2960 rl = this.registry.method_10221(value);
            out.value(rl.toString());
        }

        @Override
        public T read(JsonReader in) throws IOException {
            String rl = in.nextString();
            return this.registry.method_10223(new class_2960(rl));
        }
    }
}
