/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.sync;

import ca.lukegrahamlandry.lib.base.GenericHolder;
import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.GlobalDataWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import java.util.Objects;

public class GlobalDataSyncMessage
implements ClientSideHandler {
    String value;
    String name;
    String dir;

    public GlobalDataSyncMessage(GlobalDataWrapper<?> wrapper) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.value = wrapper.getGson().toJson(new GenericHolder(wrapper.get()));
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (DataWrapper<?> data : DataWrapper.ALL) {
            if (!(data instanceof GlobalDataWrapper) || !Objects.equals(this.dir, data.getSubDirectory()) || !data.getName().equals(this.name)) continue;
            GenericHolder syncedValue = (GenericHolder)data.getGson().fromJson(this.value, GenericHolder.class);
            ((GlobalDataWrapper)data).set(syncedValue.value);
            handled = true;
        }
        if (!handled) {
            DataWrapper.LOGGER.error("Global. Received data sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
        }
    }
}

