/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.helper.fabric;

import ca.lukegrahamlandry.lib.helper.EntityHelper;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1826;
import net.minecraft.class_5132;
import net.minecraft.class_5617;
import java.util.function.Supplier;

public class EntityHelperImpl {
    public static void attributes(Supplier<class_1299<? extends class_1309>> type, Supplier<class_5132.class_5133> builder) {
        FabricDefaultAttributeRegistry.register(type.get(), builder.get());
    }

    public static <E extends class_1297> void renderer(Supplier<class_1299<? extends E>> type, class_5617<E> renderer) {
        EntityRendererRegistry.register(type.get(), renderer);
    }

    public static EntityHelper.ModdedSpawnEggFactory getSpawnEggConstructor() {
        // fabric doesn't mess with registries, so it's safe to invoke the supplier immediately
        return (type, backgroundColor, highlightColor, props) -> new class_1826(type.get(), backgroundColor, highlightColor, props);
    }
}
