/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.data.impl;

import java.util.UUID;
import net.minecraft.class_1657;

// TODO: something clever for only syncing tracked players
// TODO: something clever for only loading players that are actually logged in for big servers

/**
 * Data is saved per uuid not per player entity so data is maintained between deaths and dimension changes.
 */
public class PlayerDataWrapper<T> extends MapDataWrapper<class_1657, UUID, T> {
    public PlayerDataWrapper(Class<T> clazz) {
        super(UUID.class, clazz);
    }

    @Override
    public UUID keyToId(class_1657 key) {
        return key.method_5667();
    }

    @Override
    public UUID stringToId(String id) {
        return UUID.fromString(id);
    }
}
