/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.sync;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.impl.MapDataWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import java.util.Objects;

public class SingleEntryMapDataSyncMessage
implements ClientSideHandler {
    String value;
    String id;
    String name;
    String dir;

    public <I> SingleEntryMapDataSyncMessage(MapDataWrapper<?, I, ?> wrapper, I id) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.id = id.toString();
        this.value = wrapper.getGson().toJson(wrapper.getById(id));
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (DataWrapper<?> data : DataWrapper.ALL) {
            if (!(data instanceof MapDataWrapper) || !Objects.equals(this.dir, data.getSubDirectory()) || !data.getName().equals(this.name)) continue;
            Object syncedValue = data.getGson().fromJson(this.value, data.clazz);
            Object syncedID = ((MapDataWrapper)data).stringToId(this.id);
            ((MapDataWrapper)data).set(syncedID, syncedValue);
            handled = true;
        }
        if (!handled) {
            DataWrapper.LOGGER.error("SingleMap. Received data sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
        }
    }
}

