/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.config;

import ca.lukegrahamlandry.lib.config.ConfigWrapper;
import ca.lukegrahamlandry.lib.network.ClientSideHandler;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSyncMessage
implements ClientSideHandler {
    static Logger LOGGER = LoggerFactory.getLogger(ConfigSyncMessage.class);
    String value;
    String name;
    String dir;

    public ConfigSyncMessage(ConfigWrapper<?> wrapper) {
        this.name = wrapper.getName();
        this.dir = wrapper.getSubDirectory();
        this.value = wrapper.getGson().toJson(wrapper.get());
    }

    @Override
    public void handle() {
        boolean handled = false;
        for (ConfigWrapper<?> config : ConfigWrapper.ALL) {
            if (config.side != ConfigWrapper.Side.SYNCED || !Objects.equals(this.name, config.getName()) || !Objects.equals(this.dir, config.getSubDirectory())) continue;
            try {
                Object syncedValue = config.getGson().fromJson(this.value, config.actualType);
                config.set(syncedValue);
            }
            catch (JsonSyntaxException e) {
                LOGGER.error("Failed to parse synced config " + this.name + " to " + config.actualType.getTypeName());
                LOGGER.error("data: " + this.value);
                e.printStackTrace();
            }
            handled = true;
        }
        if (!handled) {
            LOGGER.error("Received config sync for unknown {name: " + this.name + ", dir: " + this.dir + "}");
        }
    }
}

