/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.network;

import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public interface ClientSideHandler {
    /**
     * The method to be called when an object of this type is received, through the network, on the client.
     * It is safe to call client only code here. Although the object will be initialized on the server, this method will never be called there so client classes referenced here will not be loaded.
     */
    void handle();

    // HELPERS

    default void sendToClient(class_3222 player){
        NetworkWrapper.sendToClient(player, this);
    }

    default void sendToAllClients(){
        NetworkWrapper.sendToAllClients(this);
    }

    default void sendToTrackingClients(class_3218 level){
        NetworkWrapper.sendToTrackingClients(level, this);
    }

    default void sendToTrackingClients(class_3218 world, class_2338 pos){
        NetworkWrapper.sendToTrackingClients(world, pos, this);
    }

    default void sendToTrackingClients(class_2586 tile){
        NetworkWrapper.sendToTrackingClients(tile, this);
    }

    default void sendToTrackingClients(class_1297 entity){
        NetworkWrapper.sendToTrackingClients(entity, this);
    }

    default void sendToTrackingClientsAndSelf(class_3222 player){
        NetworkWrapper.sendToTrackingClientsAndSelf(player, this);
    }

    default class_2596<class_2602> toVanillaClientBound(){
        return (class_2596<class_2602>) NetworkWrapper.toVanillaPacket(this, true);
    }
}
