/*
 * This file is part of WrapperLib
 * Copyright 2022 LukeGrahamLandry
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

package ca.lukegrahamlandry.lib.helper;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_5132;
import net.minecraft.class_5617;

public class EntityHelper {
    /**
     * Registers attributes for a custom living entity.
     * @param type the EntityType that will use these attributes.
     * @param builder the attributes to be registered.
     */
    @ExpectPlatform
    public static void attributes(Supplier<class_1299<? extends class_1309>> type, Supplier<class_5132.class_5133> builder) {
        throw new AssertionError();
    }

    /**
     * This may ONLY be called on the CLIENT.
     * @param type the entity type that will be bound to
     * @param renderer the constructor of your EntityRenderer class
     */
    @ExpectPlatform
    public static <E extends class_1297> void renderer(Supplier<class_1299<? extends E>> type, class_5617<E> renderer) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static ModdedSpawnEggFactory getSpawnEggConstructor() {
        throw new AssertionError();
    }

    public interface ModdedSpawnEggFactory {
        class_1826 create(Supplier<class_1299<? extends class_1308>> type, int backgroundColor, int highlightColor, class_1792.class_1793 props);
    }
}
